---
title: Error 405 · Cloudflare Support docs
description: The 405 Method Not Allowed status code indicates that the origin
  server recognizes the requested resource but does not support the HTTP method
  used in the request.
lastUpdated: 2025-05-21T17:09:12.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/4xx-client-error/error-405/
  md: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/4xx-client-error/error-405/index.md
---

## 405 Method Not Allowed

The 405 Method Not Allowed status code indicates that the origin server recognizes the requested resource but does not support the HTTP method used in the request.

For more details, refer to [RFC 7231](https://tools.ietf.org/html/rfc7231).

### Common use cases

This error typically occurs when the client uses an unsupported HTTP method to interact with a specific resource. The origin server must include an `Allow` header in the response, which lists the HTTP methods supported for that resource.

For example, attempting a `POST` request on a resource that is unchangeable and only supports `GET` requests will result in a `405` error.

### Cloudflare-specific information

Cloudflare does not directly generate `405` errors. These errors are returned by the origin server when it does not allow the HTTP method used in the request. If you encounter a `405` error, review the configuration of your origin server to ensure the correct methods are enabled for the resource in question.
